/*********************************************************************
 *
 *                  Tick Manager for PIC18
 *
 *********************************************************************
 * FileName:        Tick.h
 * Dependencies:    None
 * Processor:       PIC18, PIC24F, PIC24H, dsPIC30F, dsPIC33F, PIC32
 * Compiler:        Microchip C32 v1.05 or higher
 *               Microchip C30 v3.12 or higher
 *               Microchip C18 v3.30 or higher
 *               HI-TECH PICC-18 PRO 9.63PL2 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright (C) 2002-2009 Microchip Technology Inc.  All rights
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and
 * distribute:
 * (i)  the Software when embedded on a Microchip microcontroller or
 *      digital signal controller product ("Device") which is
 *      integrated into Licensee's product; or
 * (ii) ONLY the Software driver source files ENC28J60.c, ENC28J60.h,
 *      ENCX24J600.c and ENCX24J600.h ported to a non-Microchip device
 *      used in conjunction with a Microchip ethernet controller for
 *      the sole purpose of interfacing with the ethernet controller.
 *
 * You should refer to the license agreement accompanying this
 * Software for additional information regarding your rights and
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date    Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Nilesh Rajbharti     6/28/01 Original        (Rev 1.0)
 * Nilesh Rajbharti     2/9/02  Cleanup
 * Nilesh Rajbharti     5/22/02 Rev 2.0 (See version.log for detail)
 ********************************************************************/
#ifndef __TICK_H
#define __TICK_H

#include "TCPIP.h"

// All TICKS are stored as 32-bit unsigned integers.
// This is deprecated since it conflicts with other TICK definitions used in 
// other Microchip software libraries and therefore poses a merge and maintence 
// problem.  Instead of using the TICK data type, just use the base DWORD data 
// type instead.
#if (defined(__PCH__) || defined(__PCD__))
typedef DWORD TICK;
#else
typedef __attribute__((__deprecated__)) DWORD TICK;
#endif

// This value is used by TCP and other modules to implement timeout actions.
// For this definition, the Timer must be initialized to use a 1:256 prescalar 
// in Tick.c.  If using a 32kHz watch crystal as the time base, modify the 
// Tick.c file to use no prescalar.
#define TICKS_PER_SECOND      ((GetPeripheralClock()+128ull)/256ull)   // Internal core clock drives timer with 1:256 prescaler
//#define TICKS_PER_SECOND      (32768ul)                        // 32kHz crystal drives timer with no scalar

// Represents one second in Ticks
#define TICK_SECOND            ((QWORD)TICKS_PER_SECOND)
// Represents one minute in Ticks
#define TICK_MINUTE            ((QWORD)TICKS_PER_SECOND*60ull)
// Represents one hour in Ticks
#define TICK_HOUR            ((QWORD)TICKS_PER_SECOND*3600ull)


void TickInit(void);
#if defined(__DEBUG_PUSH_TICKGET__)
union 
{
   unsigned int16 w[2];
   unsigned int32 dw;
} _g_TickPc;
#define _UPDATE_g_TickPc() _g_TickPc.dw=label_address(__TICK_PC); __TICK_PC: delay_cycles(1)
DWORD _TickGet(void);
DWORD _TickGetDiv256(void);
DWORD _TickGetDiv64K(void);
inline DWORD TickGet(void) {_UPDATE_g_TickPc(); return(_TickGet());}
inline DWORD TickGetDiv256(void) {_UPDATE_g_TickPc(); return(_TickGetDiv256());}
inline DWORD TickGetDiv64K(void) {_UPDATE_g_TickPc(); return(_TickGetDiv64K());}
#else
DWORD TickGet(void);
DWORD TickGetDiv256(void);
DWORD TickGetDiv64K(void);
#endif

DWORD TickConvertToMilliseconds(DWORD dwTickValue);
void TickUpdate(void);

#if defined(TICK_ISR_POLLING)
#define TickTask()   TickGet()
#else
#define TickTask()   
#endif

#endif
